<?php
$base = __DIR__ . '/uploads';
$files = [];
if (is_dir($base)) {
  $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($base, FilesystemIterator::SKIP_DOTS));
  foreach ($it as $f) {
    if ($f->isFile() && strtolower(substr($f->getFilename(), -4)) === '.pdf') {
      $files[] = str_replace(__DIR__.'/', '', $f->getPathname());
    }
  }
}
header('Content-Type: application/json; charset=utf-8');
echo json_encode(['count'=>count($files), 'files'=>$files], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
