<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('X-Content-Type-Options: nosniff');

function out($arr){ echo json_encode($arr, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

$config = require __DIR__ . '/../config.php';
if (!is_array($config) || empty($config['db'])) {
  out(['ok'=>false,'where'=>'config','msg'=>'config.php لا يعيد مصفوفة db']);
}

$db = $config['db'];
$mysqli = @new mysqli($db['host'], $db['user'], $db['pass'], $db['name'], 3306);
if ($mysqli->connect_errno) {
  out([
    'ok'=>false,
    'where'=>'mysqli_connect',
    'errno'=>$mysqli->connect_errno,
    'error'=>$mysqli->connect_error,
    'host'=>$db['host'],
    'user'=>$db['user'],
    'db'=>$db['name']
  ]);
}
$mysqli->set_charset($db['charset'] ?? 'utf8mb4');
$res = $mysqli->query("SELECT 1 AS one");
$row = $res ? $res->fetch_assoc() : null;
out(['ok'=>true,'ping'=>'success','select1'=>$row,'server_info'=>$mysqli->server_info]);
